#include <iostream>
#include <vector>
#include <unordered_set>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, q;
    cin >> n >> q;
    vector<int> niz(n);
    vector<int> poz(n + 1);

    for (int i = 0; i < n; ++i) {
        cin >> niz[i];
        poz[niz[i]] = i;
    }

    int prekidi = 0;
    for (int i = 1; i < n; ++i) {
        if (poz[i] > poz[i + 1]) prekidi++;
    }

    cout << prekidi << '\n';

    while (q--) {
        int i, j;
        cin >> i >> j;
        --i; --j;

        if (i == j) {
            cout << prekidi << '\n';
            continue;
        }

        int a = niz[i], b = niz[j];
        unordered_set<int> pogodi;

        for (int x : {a - 1, a, b - 1, b}) {
            if (x >= 1 && x < n) pogodi.insert(x);
        }

        for (int x : pogodi) {
            if (poz[x] > poz[x + 1]) prekidi--;
        }

        swap(niz[i], niz[j]);
        swap(poz[a], poz[b]);

        for (int x : pogodi) {
            if (poz[x] > poz[x + 1]) prekidi++;
        }

        cout << prekidi << '\n';
    }

    return 0;
}